package game;

import java.util.ArrayList;


public abstract class CollidableObject {
	public abstract IntRect getNextPosCollisionRect();
	public abstract int getNextXPos();
	public abstract int getCollisionWidth();
	public abstract IntRect getCurrentPosCollisionRect();
	public abstract int getxPos();
	public abstract int getyPos();
	public abstract int getNextYPos();
	public abstract int getCollisionHeight();
	
	

	
	public BlockInterface findAlternateFloorBlockFromRogueBlocks(ArrayList<SolidBlockSprite> blocks, BlockInterface origFloor, IntRect playerRect) {
		
		BlockInterface currentFloor = origFloor;
		
		BlockInterface tempBlock = null;
		
		int playerMaxY = (int) playerRect.getMaxY();
		
		for(int i = 0; i < blocks.size(); i++) {
			
			tempBlock = blocks.get(i);
			
			if((currentFloor == null || tempBlock.getCollisionRectMinY() < currentFloor.getCollisionRectMinY()) && tempBlock.getCollisionRectMinY() > playerMaxY) {
				if(playerRect.getMaxX() < tempBlock.getCollisionRect().getMinX() || playerRect.getMinX() > tempBlock.getCollisionRect().getMaxX()) {
					//no match
//					if(tempBlock.getName() != null) {
//					if(currentFloor == null) {
//						System.err.println("<><>DELME NULL!  rejected the moving block because it was outside the given X-range "+ tempBlock.getName());
//					} else {
//						System.err.println("<><>DELME BLOCK! rejected the moving block because it was outside the given X-range "+ tempBlock.getName());
//					}
					continue;
//				} else {
//					if(currentFloor == null)
//						System.err.println("<><>DELME NULL!  accepted the moving block " + tempBlock.getName());
//					else 
//						System.err.println("<><>DELME BLOCK! accepted the moving block " + tempBlock.getName());
				}
				
				//we have a match
				currentFloor = tempBlock;
//			} else {
//				System.err.println("rejected the moving block because it wasn't both high enough and beneath the player.  currentFloor is: " + (currentFloor == null ? "null" : (currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", currentFloor.getCollisionRectMinY(): " + currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", playerMaxY: " + playerMaxY)));
			}
			
		}
		
		return currentFloor;
	}
	
	
	

	public BlockInterface findAlternateFloorBlockFromRogueBlocksII(ArrayList<SolidBlockSprite> blocks, BlockInterface origFloor, IntRect playerCurrentRect, IntRect playerNextRect) {
		
		BlockInterface currentFloor = origFloor;
		
		BlockInterface tempBlock = null;
		
		int playerCurrentMaxY = (int) playerCurrentRect.getMaxY();
		int playerNextMaxY = (int) playerNextRect.getMaxX();
		
		for(int i = 0; i < blocks.size(); i++) {
			
			tempBlock = blocks.get(i);
			
			if(tempBlock instanceof MovingBlockSprite && ((MovingBlockSprite) tempBlock).getDir() == 'u' || tempBlock instanceof MovingBlockSprite && ((MovingBlockSprite) tempBlock).getDir() == 'd' ) {
				//check based on different criteria
				
//				int moveSpeed = ((MovingBlockSprite) tempBlock).getMoveSpeed();
//				
//				if(currentFloor == null || (tempBlock.getCollisionRectMinY() + moveSpeed < currentFloor.getCollisionRectMinY() && tempBlock.getCollisionRectMinY() + moveSpeed > playerCurrentMaxY)) {
//					if(playerCurrentRect.getMaxX() < tempBlock.getCollisionRect().getMinX() || playerCurrentRect.getMinX() > tempBlock.getCollisionRect().getMaxX()) {
//						//no match
//						continue;
//					}
//					
//					//we have a match
//					currentFloor = tempBlock;
//				}
				
				
				if(currentFloor == null || (tempBlock.getCollisionRectMinY() < currentFloor.getCollisionRectMinY() && tempBlock.getCollisionRectMinY() > playerCurrentMaxY)) {
					if(playerNextRect.getMaxX() < tempBlock.getCollisionRect().getMinX() || playerNextRect.getMinX() > tempBlock.getCollisionRect().getMaxX()) {
						//no match
	//					if(tempBlock.getName() != null) {
	//						System.err.println("rejected the moving block because it was outside the given X-range");
	//					}
						continue;
	//				} else {
	//					System.err.println("accepted the moving block");
					}
					
					//we have a match
					currentFloor = tempBlock;
	//			} else {
	//				System.err.println("rejected the moving block because it wasn't both high enough and beneath the player.  currentFloor is: " + (currentFloor == null ? "null" : (currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", currentFloor.getCollisionRectMinY(): " + currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", playerMaxY: " + playerMaxY)));
				}
				
				
				
			} else {
				
				if(currentFloor == null || (tempBlock.getCollisionRectMinY() < currentFloor.getCollisionRectMinY() && tempBlock.getCollisionRectMinY() > playerCurrentMaxY)) {
					if(playerCurrentRect.getMaxX() < tempBlock.getCollisionRect().getMinX() || playerCurrentRect.getMinX() > tempBlock.getCollisionRect().getMaxX()) {
						//no match
	//					if(tempBlock.getName() != null) {
	//						System.err.println("rejected the moving block because it was outside the given X-range");
	//					}
						continue;
	//				} else {
	//					System.err.println("accepted the moving block");
					}
					
					//we have a match
					currentFloor = tempBlock;
	//			} else {
	//				System.err.println("rejected the moving block because it wasn't both high enough and beneath the player.  currentFloor is: " + (currentFloor == null ? "null" : (currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", currentFloor.getCollisionRectMinY(): " + currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", playerMaxY: " + playerMaxY)));
				}
				
			}
		}
		
		return currentFloor;
	}
	
	
	

	public BlockInterface findAlternateFloorBlockFromRogueBlocksIII(ArrayList<SolidBlockSprite> blocks, BlockInterface origFloor, IntRect playerRect) {
		
		BlockInterface currentFloor = origFloor;
		
		BlockInterface tempBlock = null;
		
		int playerCenterY = (int) playerRect.getCenter().y;
		
		for(int i = 0; i < blocks.size(); i++) {
			
			tempBlock = blocks.get(i);
			
			if(tempBlock.getCollisionRectMinY() > playerCenterY) {
				if(playerRect.getMaxX() < tempBlock.getCollisionRect().getMinX() || playerRect.getMinX() > tempBlock.getCollisionRect().getMaxX()) {
					//no match
//					if(tempBlock.getName() != null) {
//					if(currentFloor == null) {
//						System.err.println("<><>DELME NULL!  rejected the moving block because it was outside the given X-range "+ tempBlock.getName());
//					} else {
//						System.err.println("<><>DELME BLOCK! rejected the moving block because it was outside the given X-range "+ tempBlock.getName());
//					}
					continue;
//				} else {
//					if(currentFloor == null)
//						System.err.println("<><>DELME NULL!  accepted the moving block " + tempBlock.getName());
//					else 
//						System.err.println("<><>DELME BLOCK! accepted the moving block " + tempBlock.getName());
				}
				
				if(currentFloor == null || tempBlock.getCollisionRectMinY() < currentFloor.getCollisionRectMinY() ) {
					//we have a match
					currentFloor = tempBlock;
				}
//			} else {
//				System.err.println("rejected the moving block because it wasn't both high enough and beneath the player.  currentFloor is: " + (currentFloor == null ? "null" : (currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", currentFloor.getCollisionRectMinY(): " + currentFloor.getCollisionRectMinY() + ", tempBlock.getCollisionRectMinY(): " + tempBlock.getCollisionRectMinY() + ", playerMaxY: " + playerMaxY)));
			}
			
		}
		
		return currentFloor;
	}
	
	
	
	
	
	
	public BlockInterface findAlternateCeilingBlockFromRogueBlocks(ArrayList<SolidBlockSprite> blocks, BlockInterface origCeiling, IntRect playerRect) {
		
		BlockInterface currentCeiling = origCeiling;
		
		BlockInterface tempBlock = null;
		
		int playerMinY = (int) playerRect.getMinY();
//		int playerCenterY = (int) playerRect.getCenter().y;
		
		for(int i = 0; i < blocks.size(); i++) {
			
			tempBlock = blocks.get(i);
			
			if(tempBlock.isPassThrough())
				continue;
			
			if(tempBlock.getCollisionRectMaxY() < playerMinY && (currentCeiling == null || tempBlock.getCollisionRectMaxY() > currentCeiling.getCollisionRectMaxY())) {
				if(playerRect.getMaxX() < tempBlock.getCollisionRect().getMinX() || playerRect.getMinX() > tempBlock.getCollisionRect().getMaxX()) {
					//no match
					continue;
				}
				
				//we have a match
				currentCeiling = tempBlock;
			}
			
		}
		
		return currentCeiling;
	}
	
	
}
